import numpy as np
import matplotlib.pyplot as plt

# remplacer "villani.txt" par l'adresse complète du fichier 
# "E:\maths\python\villani.txt"
f = open("villani.txt", 'r')
texte = f.read()

# passage en minuscules
texte = texte.lower()
# remplacement des caractères accentués
Remplacer = {"é":"e","è":"e","ê":"e","ë":"e","à":"a","â":"a","ä":"a","ù":"u",
            "ü":"u","î":"i","ï":"i","ô":"o","ö":"o","ç":"c"}
for carac in Remplacer:
    texte=texte.replace(carac, Remplacer[carac])
# suppression des caractères non alphabétiques
Alphabet = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q",
            "r","s","t","u","v","w","x","y","z"]
for carac in texte:
    if carac not in Alphabet:
        texte = texte.replace(carac,"")

# occurence des lettres de l'alphabet
D={}
for lettre in Alphabet:
    D[lettre] = texte.count(lettre)

N = sum(D.values())
for a in D:
    D[a] = D[a] / N

plt.bar(np.arange(len(D)) + 0.1, [D[a] for a in Alphabet], 0.5, color = 'r')
plt.xticks(np.arange(len(D)) + 0.1, [a for a in Alphabet])
plt.show()

f.close()

